
Type TWaterContainer
	Field _waveController:TWaveController
	Field _fluidController:TFluidDragController
	Field _position:Vector2 = Vector2.Zero()	'top left
	Field _size:Vector2 = Vector2.Zero()
	Field _gravity:Vector2 = Vector2.Zero() ' gravity inside the water, used for bouyancy calculation
	Field _circleBrush:TCircleBrush
	Field _rectBrush:TRectangleBrush
	Field _detailLevel:Int	'node Count
	Field _color:TColor
	Field _lineColor:TColor
	
	Function Create:TWaterContainer(physics:TPhysicsSimulator, position:Vector2, size:Vector2, gravity:Vector2, detailLevel:Int = 100)
		Local w:TWaterContainer = New TWaterContainer
		w._position.Set(position)
		w._size.Set(size)
		w._gravity.Set(gravity)
		w._detailLevel = detailLevel
		w.Load(physics)
		Return w
	End Function
	
	Method AddGeom(g:TGeom)
		_fluidController.AddGeom(g)
	End Method
	
	Method AddOnEntryHandler(o:Object)
		_fluidController.AddOnEntryListener(o)
	End Method
		
	Method Draw()
	'	_rectBrush.Draw(Vector2.AddVectors(_position, Vector2.ScaleVector(_size, .5)))
'		For Local i:Int = 0 To _waveController.GetNodeCount() - 1
'			Local x:Float = _waveController._xPosition[i]
'			Local y:Float = _waveController._currentWave[i] + _waveController._position.Y
'			_circleBrush.Draw(Vector2.Create(x, y))
'		Next
		_Draw2()
	End Method
	
	Method _Draw2()
		_color.Set()

		For Local i:Int = 0 To _waveController.GetNodeCount() - 3 Step 2
			Local x:Float = _waveController._xPosition[i]
			Local nx:Float = _waveController._xPosition[i + 2]
			Local y:Float = _waveController._currentWave[i] + _waveController._position.Y
			Local ny:Float = _waveController._currentWave[i + 2] + _waveController._position.Y		
			Local xyArray:Float[8]
			xyArray[0] = x
			xyArray[1] = y
			xyArray[2] = nx
			xyArray[3] = ny
			xyArray[4] = nx
			xyArray[5] = _position.Y + _size.Y
			xyArray[6] = x
			xyArray[7] = _position.Y + _size.Y

			DrawPoly(xyArray)
		Next
		For Local i:Int = 1 To _waveController.GetNodeCount() - 3 Step 2
			Local x:Float = _waveController._xPosition[i]
			Local nx:Float = _waveController._xPosition[i + 2]
			Local y:Float = _waveController._currentWave[i] + _waveController._position.Y
			Local ny:Float = _waveController._currentWave[i + 2] + _waveController._position.Y
			Local xyArray:Float[8]
			xyArray[0] = x
			xyArray[1] = y
			xyArray[2] = nx
			xyArray[3] = ny
			xyArray[4] = nx
			xyArray[5] = _position.Y + _size.Y
			xyArray[6] = x
			xyArray[7] = _position.Y + _size.Y

			DrawPoly(xyArray)
		Next
		' draw lines
		_lineColor.Set()
		For Local i:Int = 0 To _waveController.GetNodeCount() - 3 Step 2
			Local x:Float = _waveController._xPosition[i]
			Local nx:Float = _waveController._xPosition[i + 2]
			Local y:Float = _waveController._currentWave[i] + _waveController._position.Y
			Local ny:Float = _waveController._currentWave[i + 2] + _waveController._position.Y		
			DrawLine(x, y, nx, ny)
		Next
		
		For Local i:Int = 1 To _waveController.GetNodeCount() - 3 Step 2
			Local x:Float = _waveController._xPosition[i]
			Local nx:Float = _waveController._xPosition[i + 2]
			Local y:Float = _waveController._currentWave[i] + _waveController._position.Y
			Local ny:Float = _waveController._currentWave[i + 2] + _waveController._position.Y
			DrawLine(x, y, nx, ny)
		Next
		DrawLine(_position.X, _position.Y, _position.X + _waveController._singleWaveWidth, _position.Y)
		DrawLine(_position.X + _size.X - _waveController._singleWaveWidth, _position.Y, _position.X + _size.X, _position.Y)
		_color.Set()
		DrawRect(_position.X, _position.Y, _waveController._singleWaveWidth, _size.Y)
		DrawRect(_position.X + _size.X - _waveController._singleWaveWidth, _position.Y, _waveController._singleWaveWidth, _size.Y)
		SetColor(255, 255, 255)
		setalpha(1)
	End Method
	
	Method Load(physics:TPhysicsSimulator)
		_color = TColor.Create(.6 * 255, 222, 140, 45)
		_lineColor = TColor.Create(.75 * 255, 255, 255, 255)
		
		_waveController = TWaveController.Create(_position, _size, _detailLevel)
		_waveController.SetWaveGeneratorMax(- 500)
		_waveController.SetWaveGeneratorMin(500)
		_waveController.SetWaveGeneratorStep(.001)
		_waveController.SetDampningCoefficient(.96)
		_waveController.SetFrequency(.010)
		_waveController.Initialize()
		_waveController.Disturb(10, - 100)
		
		_fluidController = TFluidDragController.Create(_waveController, .01, .2, .5, _gravity)
		
		physics.AddController(_waveController)
		physics.AddController(_fluidController)
		
		_circleBrush = TCircleBrush.Create(3, TColor.White, TColor.White)
		_rectBrush = TRectangleBrush.Create(_size.X, _size.Y, TColor.Create(100, 65, 128, 199), TColor.White)
		
		_fluidController.AddOnEntryListener(Self)
	End Method
	
	' handle the 'on Entry' event for
	' hitting the water.
	Method SendMessage:Object(sender:Object, args:Object)
		If TFluidDragController(sender) Then
			Local data:TFluidEntryEventArgs = TFluidEntryEventArgs(args)
			Local geom:TGeom = data.geom
			Local vector:Vector2 = geom._position ' get the center of the object in the water.
			Local index:Int = Floor((vector.X - _waveController._xPosition[0]) / _waveController._singleWaveWidth)
			' handle boundry conditions
			If index > _waveController._nodeCount - 2 Then index = _waveController._nodeCount - 2
			If index < 0 Then index = 0
			'disturb the water			
			If data.isEntry Then
				_waveController.Disturb(index, (_position.Y - vector.Y) *.5)
			Else
				_waveController.Disturb(index, - (_position.Y - vector.Y) *.25)
			End If
		
		End If
		Return Null
	End Method
End Type
